require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/roncatpottedclover.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatpottedclover.xml"),
    Asset("ANIM", "anim/roncatpottedclover_moonrock.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatpottedclover_moonrock.xml"),
    Asset("ANIM", "anim/roncatpottedclover_obsidian.zip"),
	Asset("ATLAS", "images/inventoryimages/roncatpottedclover_obsidian.xml"),
}

local prefabs =
{
    "collapse_small",
}

-- Decide description based on viewer's distance
local function getdesc(inst, viewer)
    if not viewer:HasTag("playerghost") then
        local distSq = inst:GetDistanceSqToInst(viewer)
        local mod = (distSq < 15*15 and "NEAR") or "FAR"
        local desc = GetDescription(string.upper(viewer.prefab), inst, mod)
        return desc
    end
	return GetDescription(viewer, inst)
end


local function onhammered(inst, worker)
    SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst.components.lootdropper:DropLoot()
    inst.SoundEmitter:PlaySound("dontstarve/common/destroy_pot")
    inst:Remove()
end

local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddSoundEmitter()
    inst.entity:AddAnimState()

	inst:AddTag("roncatluckprotector") -- Being near this will prevent jinx from occuring
	
    --inst:AddComponent("sanityaura")
    --inst.components.sanityaura.aura = TUNING.SANITYAURA_TINY

    inst:AddComponent("inspectable")
    inst.components.inspectable.description = getdesc

    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(1)
    inst.components.workable:SetOnFinishCallback(onhammered)

    inst:AddComponent("lootdropper")

    return inst
end
local function stone()
	local inst = fn()
	
	local minimap = inst.entity:AddMiniMapEntity()
	
    inst.AnimState:SetBank("roncatpottedclover")
    inst.AnimState:SetBuild("roncatpottedclover")
    inst.AnimState:PlayAnimation("anim")
	
    minimap:SetIcon("roncatpottedclover.tex")
	
    MakeMediumBurnable(inst)
    MakeSmallPropagator(inst)
	
    return inst
end
local function moonrock()
	local inst = fn()
	
	local minimap = inst.entity:AddMiniMapEntity()
	
    inst.AnimState:SetBank("roncatpottedclover_moonrock")
    inst.AnimState:SetBuild("roncatpottedclover_moonrock")
    inst.AnimState:PlayAnimation("anim")
	
    minimap:SetIcon("roncatpottedclover_moonrock.tex")
	
	inst:AddTag("roncatmeteorrepeller") -- Repels meteors
	
    inst.components.workable:SetWorkLeft(5)
	
    inst.components.inspectable.nameoverride = "roncatpottedclover"
	
    return inst
end

local function obsidian()
	local inst = fn()
	
	local minimap = inst.entity:AddMiniMapEntity()
	
    inst.AnimState:SetBank("roncatpottedclover_obsidian")
    inst.AnimState:SetBuild("roncatpottedclover_obsidian")
    inst.AnimState:PlayAnimation("anim")
	
    minimap:SetIcon("roncatpottedclover_obsidian.tex")
	
	inst:AddTag("roncatfirerainrepeller") -- Repels fire rain
	
    inst.components.workable:SetWorkLeft(5)
	
    inst.components.inspectable.nameoverride = "roncatpottedclover"
	
    return inst
end

return Prefab("cave/objects/roncatpottedclover", stone, assets, prefabs),
    MakePlacer("common/roncatpottedclover_placer", "roncatpottedclover", "roncatpottedclover", "anim"),
	Prefab("cave/objects/roncatpottedclover_moonrock", moonrock, assets, prefabs),
    MakePlacer("common/roncatpottedclover_moonrock_placer", "roncatpottedclover_moonrock", "roncatpottedclover_moonrock", "anim"),
	Prefab("cave/objects/roncatpottedclover_obsidian", obsidian, assets, prefabs),
    MakePlacer("common/roncatpottedclover_obsidian_placer", "roncatpottedclover_obsidian", "roncatpottedclover_obsidian", "anim")